% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_imp_count_multi_2018-02-23.R
\name{imp_count_multi}
\alias{imp_count_multi}
\title{The function for hierarchical imputation of variables with count data.}
\usage{
imp_count_multi(y_imp, X_imp, Z_imp, clID, nitt = 22000, burnin = 2000,
  thin = 20, pvalue = 0.2, rounding_degrees = c(1, 10, 100, 1000))
}
\arguments{
\item{y_imp}{A Vector with the variable to impute.}

\item{X_imp}{A data.frame with the fixed effects variables.}

\item{Z_imp}{A data.frame with the random effects variables.}

\item{clID}{A vector with the cluster ID.}

\item{nitt}{An integer defining number of MCMC iterations (see MCMCglmm).}

\item{burnin}{burnin A numeric value between 0 and 1 for the desired percentage of
Gibbs samples that shall be regarded as burnin.}

\item{thin}{An integer to set the thinning interval range. If thin = 1,
every iteration of the Gibbs-sampling chain will be kept. For highly autocorrelated
chains, that are only examined by few iterations (say less than 1000).}

\item{pvalue}{A numeric between 0 and 1 denoting the threshold of p-values a variable in the imputation
model should not exceed. If they do, they are excluded from the imputation model.}

\item{rounding_degrees}{A numeric vector with the presumed rounding degrees.}
}
\value{
A list with 1. 'y_ret' the n x 1 data.frame with the original and imputed values.
2. 'Sol' the Gibbs-samples for the fixed effects parameters.
3. 'VCV' the Gibbs-samples for variance parameters.
}
\description{
The function is called by the wrapper.
}
