% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasso.R
\name{hmlasso}
\alias{hmlasso}
\title{Fit a model using a design matrix}
\usage{
hmlasso(X, y, family = "gaussian", impl = "cpp",
  lambda.min.ratio = 0.01, nlambda = 100, lambda = NULL,
  min_eig_th = 1e-06, use = "pairwise.complete.obs",
  positify = "diag", weight_power = 1, eig_tol = 1e-08,
  eig_maxitr = 1e+08, mu = 1, verbose = FALSE, ...)
}
\arguments{
\item{X}{matrix of explanatory variables}

\item{y}{vector of objective variable}

\item{family}{family of regression: "gaussian" (default) or "binomial"}

\item{impl}{implementation language of optimization (only "cpp" is supported)}

\item{lambda.min.ratio}{ratio of max lambda and min lambda (ignored if lambda is specified)}

\item{nlambda}{the number of lambda (ignored if lambda is specified)}

\item{lambda}{lambda sequence}

\item{min_eig_th}{threshold of the minimum eigenvalue in the PSD matrix problem.}

\item{use}{method to calculate correlation matrix from missing data (default "pairwise.complete.obs")}

\item{positify}{method for solving PSD matrix}

\item{weight_power}{weighting power (default 0 meaning no-weighting)}

\item{eig_tol}{tol parameter in eigs_sym function}

\item{eig_maxitr}{maxitr parameter in eigs_sym}

\item{mu}{augmented Lagrangian parameter}

\item{verbose}{whether output verbose warnings and messages (default FALSE)}

\item{...}{parameters for optimization}
}
\value{
lasso model
\item{beta}{coefficients}
\item{beta_standard}{standardized coefficients}
\item{a0}{intercepts}
\item{lambda}{regularization parameters}
\item{family}{family}
}
\description{
Fit a model using a design matrix
}
\examples{
X_incompl <- as.matrix(iris[, 1:3])
X_incompl[1:5,1] <- NA
X_incompl[6:10,2] <- NA
y <- iris[, 4]
fit <- hmlasso(X_incompl, y, nlambda=50, lambda.min.ratio=1e-2)
plot(fit)

}
