% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.R
\name{tmr_stop}
\alias{tmr_stop}
\title{Stop hms Timer}
\usage{
tmr_stop(x)
}
\arguments{
\item{x}{A \code{\link[=hms_timer]{hms_timer()}}.}
}
\value{
A stopped \code{\link[=hms_timer]{hms_timer()}}.
}
\description{
Stops a \code{\link[=hms_timer]{hms_timer()}} after updating it to the elapsed time.
}
\details{
If the \code{\link[=hms_timer]{hms_timer()}} is already stopped, the function
simply issues a warning and returns the original object.
}
\examples{
tmr <- tmr_stop(tmr_timer(start = TRUE))
print(tmr_elapsed(tmr))
Sys.sleep(0.01)
print(tmr_elapsed(tmr))
}
\seealso{
Other start_stop: 
\code{\link{tmr_elapsed}()},
\code{\link{tmr_is_started}()},
\code{\link{tmr_is_stopped}()},
\code{\link{tmr_print}()},
\code{\link{tmr_reset}()},
\code{\link{tmr_start}()},
\code{\link{tmr_timer}()}
}
\concept{start_stop}
