% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2kyears_temp.R
\name{plot_temp2k}
\alias{plot_temp2k}
\title{Download and plot essential climate data}
\usage{
plot_temp2k(
  dataset = get_temp2k(),
  instrumental = TRUE,
  filtered = TRUE,
  print = TRUE
)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_temp2k}}

\item{instrumental}{(boolean) Include the Cowtan & Way instrumental temperatures through 2017. Defaults to TRUE.}

\item{filtered}{(boolean) Use the filtered temperatures provided by PAGES2k Consortium. Temperatures filtered using a 31-year Butterworth filter. Defaults to TRUE.}

\item{print}{(boolean) Display temperature anomaly ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with temperature anomaly chart
}
\description{
Plots the Common Era 2000-year global temperature anomaly retrieved using \code{get_temp2k()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_temp2k} invisibly returns a ggplot2 object with a pre-defined temperature anomaly chart using data from \code{get_temp2k}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\dontrun{
# Fetch temperature anomaly:
anomaly <- get_temp2k()
#
# Plot output using package's built-in ggplot2 defaults
plot_temp2k(anomaly)

# Or just call plot_temp2k(), which defaults to get_temp2k() dataset
plot_temp2k()

p <- plot_temp2k(anomaly, print = FALSE)
p + ggplot2::labs(title='Temperature Increase in the Common Era') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
