% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaice.R
\name{get_seaice}
\alias{get_seaice}
\title{Download and plot essential climate data}
\usage{
get_seaice(
  pole = "N",
  month = "07",
  measure = "extent",
  use_cache = TRUE,
  write_cache = FALSE
)
}
\arguments{
\item{pole}{'N' for Arctic or 'S' for Antarctic}

\item{month}{2-digit month to retrieve sea ice for, defaults to '07' (July)}

\item{measure}{Must be 'extent' or 'area', defaults to 'extent'. Please see terminology link in references for details.}

\item{use_cache}{(boolean) Return cached data if available, defaults to TRUE. Use FALSE to fetch updated data, or to change pole or month in cache.}

\item{write_cache}{(boolean) Write data to cache, defaults to FALSE. Use TRUE to write data to cache for later use.}
}
\value{
Invisibly returns a tibble with the annual series of monthly Sea Ice Index since 1979 (in million square km).

\code{get_seaice} invisibly returns a tibble with annual series of monthly Sea Ice Index since 1979 (in million square km).

User may select Arctic or Antarctic sea ice extent or area (in millions of square kilometers) by year for a given month, specified by argument \code{month}.
Defaults to Arctic July sea ice extent.  \url{https://nsidc.org/arcticseaicenews/faq/#area_extent}
}
\description{
Retrieves Arctic or Antarctic annual Sea Ice Index (in million square km).
Source is the National Snow and Ice Data Center, defaults to Arctic (Northern Hemisphere) July sea ice extent.
\url{https://nsidc.org/data/seaice_index/archives} \cr \cr
}
\examples{
\donttest{
# Fetch sea ice from cache if available:
seaice <- get_seaice()
#
# Force cache refresh:
seaice <- get_seaice(use_cache = FALSE)
# change region and month
seaice <- get_seaice(pole='S', month='09', use_cache = FALSE)
#
# Review cache contents and last update dates:
hockeystick_cache_details()
#
# Plot output using package's built-in ggplot2 settings
plot_seaice(seaice) }

}
\references{
\itemize{
\item NSIDC Data Archive: \url{https://nsidc.org/data/seaice_index/archives}
\item All About Sea Ice: \url{https://nsidc.org/cryosphere/seaice/index.html}
\item Sea Ice terminology: \url{https://nsidc.org/cryosphere/seaice/data/terminology.html}
}
}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
