% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcInSampleError.R
\name{calcInSampleError}
\alias{calcInSampleError}
\title{Calculate index errors in sample}
\usage{
calcInSampleError(pred_df, index, ...)
}
\arguments{
\item{pred_df}{Set of sales against which to test predictions}

\item{index}{Index (of class `ts`) to be tested for accuracy}

\item{...}{Additional Arguments}
}
\value{
object of class `hpiaccuracy` inheriting from class `data.frame`
containing the following fields:
\describe{
  \item{pair_id}{Uniq Pair ID number}
  \item{price}{Transaction Price}
  \item{pred_price}{Predicted price}
  \item{error}{(Prediction - Actual) / Actual}
  \item{log_error}{log(prediction) - log(actual)}
  \item{pred_period}{Period of the prediction}
}
}
\description{
Estimate the predictive error of an index via an in-sample approach.
}
\section{Further Details}{

In addition to being a stand-alone function, it is also used by `calcForecastError`
and `calcKFoldError``
}

\examples{

 # Load example data
 data(ex_sales)

 # Create index with raw transaction data
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Calculate accuracy
 in_accr <- calcInSampleError(pred_df = rt_index$data,
                              index = rt_index$index$value)

}
