% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{apply.term.filters}
\alias{apply.term.filters}
\title{Apply a list of term filters to a given plotting context}
\usage{
apply.term.filters(hpo.terms, plotting.context, term.filters,
  starting.terms = NULL)
}
\arguments{
\item{hpo.terms}{R-Object representation of HPO}

\item{plotting.context}{List object with hpo.phenotypes slot for list of character vectors of terms}

\item{term.filters}{List of term filtering functions}

\item{starting.terms}{Character vector of HPO term codes to filter. Defaults to all terms in the `hpo.phenotypes' element of plotting.context, if it is present}
}
\value{
Character vector of terms
}
\description{
Apply a list of term filters to a given plotting context
}
\examples{
data(hpo.terms)
apply.term.filters(hpo.terms=hpo.terms, plotting.context=list(
hpo.phenotypes=list(Case1="HP:0001873")), term.filters=list(remove.links))
}

