% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ice.R
\name{ice}
\alias{ice}
\alias{ice.default}
\alias{ice.ranger}
\alias{ice.Learner}
\alias{ice.explainer}
\title{Individual Conditional Expectations}
\usage{
ice(object, ...)

\method{ice}{default}(
  object,
  v,
  X,
  pred_fun = stats::predict,
  BY = NULL,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 100L,
  ...
)

\method{ice}{ranger}(
  object,
  v,
  X,
  pred_fun = function(m, X, ...) stats::predict(m, X, ...)$predictions,
  BY = NULL,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 100,
  ...
)

\method{ice}{Learner}(
  object,
  v,
  X,
  pred_fun = NULL,
  BY = NULL,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 100L,
  ...
)

\method{ice}{explainer}(
  object,
  v = v,
  X = object[["data"]],
  pred_fun = object[["predict_function"]],
  BY = NULL,
  grid = NULL,
  grid_size = 49L,
  trim = c(0.01, 0.99),
  strategy = c("uniform", "quantile"),
  n_max = 100,
  ...
)
}
\arguments{
\item{object}{Fitted model object.}

\item{...}{Additional arguments passed to \code{pred_fun(object, X, ...)},
for instance \code{type = "response"} in a \code{\link[=glm]{glm()}} model.}

\item{v}{Vector of feature names, by default \code{colnames(X)}.}

\item{X}{A data.frame or matrix serving as background dataset.}

\item{pred_fun}{Prediction function of the form \verb{function(object, X, ...)},
providing \eqn{K \ge 1} predictions per row. Its first argument represents the
model \code{object}, its second argument a data structure like \code{X}. Additional arguments
(such as \code{type = "response"} in a GLM, or \code{reshape = TRUE} in a multiclass XGBoost
model) can be passed via \code{...}. The default, \code{\link[stats:predict]{stats::predict()}}, will work in
most cases.}

\item{BY}{Optional grouping vector/matrix/data.frame (up to two columns),
or up to two column names. Unlike with \code{\link[=partial_dep]{partial_dep()}}, these variables are not
binned. The first variable is visualized on the color scale, while the second
one goes into a \code{facet_wrap()}. Thus, make sure that the second variable is
discrete.}

\item{grid}{Evaluation grid. A vector (if \code{length(v) == 1L}), or a matrix/data.frame
otherwise. If \code{NULL}, calculated via \code{\link[=multivariate_grid]{multivariate_grid()}}.}

\item{grid_size}{Controls the approximate grid size. If \code{x} has p columns, then each
(non-discrete) column will be reduced to about the p-th root of \code{grid_size} values.}

\item{trim}{The default \code{c(0.01, 0.99)} means that values outside the
1\% and 99\% quantiles of non-discrete numeric columns are removed before calculation
of grid values. Set to \code{0:1} for no trimming.}

\item{strategy}{How to find grid values of non-discrete numeric columns?
Either "uniform" or "quantile", see description of \code{\link[=univariate_grid]{univariate_grid()}}.}

\item{n_max}{If \code{X} has more than \code{n_max} rows, a random sample of \code{n_max} rows is
selected from \code{X}. In this case, set a random seed for reproducibility.}
}
\value{
An object of class "ice" containing these elements:
\itemize{
\item \code{data}: data.frame containing the ice values.
\item \code{grid}: Vector, matrix or data.frame of grid values.
\item \code{v}: Same as input \code{v}.
\item \code{K}: Number of columns of prediction matrix.
\item \code{pred_names}: Column names of prediction matrix.
\item \code{by_names}: Column name(s) of grouping variable(s) (or \code{NULL}).
}
}
\description{
Disaggregated partial dependencies, see reference. The plot method supports
up to two grouping variables via \code{BY}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ice(default)}: Default method.

\item \code{ice(ranger)}: Method for "ranger" models.

\item \code{ice(Learner)}: Method for "mlr3" models.

\item \code{ice(explainer)}: Method for DALEX "explainer".

}}
\examples{
# MODEL 1: Linear regression
fit <- lm(Sepal.Length ~ . + Species * Petal.Length, data = iris)
plot(ice(fit, v = "Sepal.Width", X = iris))

# Stratified by one variable
ic <- ice(fit, v = "Petal.Length", X = iris, BY = "Species")
ic
plot(ic)
plot(ic, center = TRUE)

# Stratified by two variables (the second one goes into facets)
ic <- ice(fit, v = "Petal.Length", X = iris, BY = c("Petal.Width", "Species"))
plot(ic)
plot(ic, center = TRUE)

# MODEL 2: Multi-response linear regression
fit <- lm(as.matrix(iris[1:2]) ~ Petal.Length + Petal.Width * Species, data = iris)
ic <- ice(fit, v = "Petal.Width", X = iris, BY = iris$Species)
plot(ic)
plot(ic, center = TRUE)

# MODEL 3: Gamma GLM -> pass options to predict() via ...
fit <- glm(Sepal.Length ~ ., data = iris, family = Gamma(link = log))
plot(ice(fit, v = "Petal.Length", X = iris, BY = "Species"))
plot(ice(fit, v = "Petal.Length", X = iris, type = "response", BY = "Species"))
}
\references{
Goldstein, Alex, and Adam Kapelner and Justin Bleich and Emil Pitkin.
\emph{Peeking inside the black box: Visualizing statistical learning with plots of individual conditional expectation.}
Journal of Computational and Graphical Statistics, 24, no. 1 (2015): 44-65.
}
