% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{li}
\alias{li}
\title{Generate the <li> HTML tag.}
\usage{
li(..., attr = NULL, separate = FALSE, collapse = "")
}
\arguments{
\item{...}{A string or vector of content to pass to the tag.}

\item{attr}{A named list or named vector, names are attribute names and values are attribute values.}

\item{separate}{TRUE/FALSE, If TRUE, returns separate tags for each item of ...; if FALSE, returns one tag with the items of ... in the tag content.}

\item{collapse}{A string. If NULL, returns a vector the same length as ... instead of collapsing the tags into one string.}
}
\value{
A HTML tag string.
}
\description{
The <li> HTML element is used to represent an item in a list. It must be contained in a parent element: an ordered list (ol), an unordered list (ul), or a menu (menu). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter.
}
\details{
Learn more at \url{https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li}.
}
\examples{
li(attr = list(class = "test"))
}
