% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_mass_functions.R
\name{bone_mass_age}
\alias{bone_mass_age}
\title{Predict bone mass.}
\usage{
bone_mass_age(age_years, age_months, height, weight, gender)
}
\arguments{
\item{age_years}{Vector of ages in years.}

\item{age_months}{Vector of ages in months.}

\item{height}{Vector of heights in cm.}

\item{weight}{Vector of body weights in kg.}

\item{gender}{Vector of genders, either 'Male' or 'Female'.}
}
\value{
Vector of bone masses.
}
\description{
Predict bone mass from age_years, height, weight, gender, using logistic
equations fit to data from Baxter-Jones et al. 2011, or for infants < 1
year, using equation from Koo et al. 2000 (See Price et al. 2003)
}
