% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/safe-callback.R
\name{safe_callback}
\alias{safe_callback}
\title{Generate a safe R callback.}
\usage{
safe_callback(f)
}
\arguments{
\item{f}{A function.}
}
\description{
Whenever an R callback function is passed to Rcurl, it needs to be wrapped
in this handler which converts errors and interrupts to the appropriate
values that cause RCurl to terminate a request
}
\examples{
f1 <- function(x) {
  if (x < 0) stop("Negative value")
  sqrt(x)
}
f2 <- safe_callback(f1)
f2(-10)
}

