% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{get.t1d.subset}
\alias{get.t1d.subset}
\title{Obtain subset of ranged object overlapping known T1D associated genomic regions}
\usage{
get.t1d.subset(X, T1D.only = TRUE, build = NULL, ichip.regions = NULL,
  T1D.regions = NULL, invert = FALSE)
}
\arguments{
\item{X}{GRanges or RangedData object, ranged object for which you want the T1D subset
of ranges/SNPs.}

\item{T1D.only}{logical, standard is to return type 1 diabetes (T1D) regions subset, but
if this parameter is set to FALSE, will return the subset for all 12 autoimmune diseases
mapped by the ImmunoChip consortium. (Cortes and Brown, 2010).}

\item{build}{e.g, 36/hg18 or 37/hg19, if left as NULL current getOption('ucsc') will
be used.}

\item{ichip.regions}{GRanges or RangedData object, only use if you need to provide for a
build other than 36 or 37 (hg18/hg19), or for multiple lookups to avoid reloading each time}

\item{T1D.regions}{GRanges or RangedData object, only use if you need to provide for a
build other than 36 or 37 (hg18/hg19), or for multiple lookups to avoid reloading each time.}

\item{invert}{logical, set to TRUE if you wish to get the set of NON-T1D regions, or
non-immune dense regions when T1D.only=FALSE.}
}
\value{
a GRanges object with the specified type 1 diabetes/autoimmune (or inverse) ranges
}
\description{
Return subset of a ranged object that overlaps ichip dense mapped regions. For type 1 diabetes
and autoimmune disesase researchers.
}
\examples{
\donttest{
# all.reg <- rranges(10000)
# t1d <- get.t1d.subset(all.reg) # T1D regions
# non.autoimmune <- get.t1d.subset(T1D.only=FALSE,build=36,invert=TRUE) # non-autoimmune regions
}
}
