% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{invGRanges}
\alias{invGRanges}
\title{Invert a ranged object
Select the empty space between ranges for the whole genome, for instance you may want
to overlap with everything NOT in a set of ranges.}
\usage{
invGRanges(X, inclusive = FALSE, build = NULL,
  pad.missing.autosomes = TRUE)
}
\arguments{
\item{X}{a ranged object, GRanges, RangedData or ChipInfo}

\item{inclusive}{logical, TRUE if the ends of ranges should be in the inverted object}

\item{build}{character, "hg18" or "hg19" (or 36/37) to show which reference to retrieve. The 
default when build is NULL is to use the build from the current ChipInfo annotation}

\item{pad.missing.autosomes}{logical, whether to add entire chromosomes to the inverted
range object when they are not contained within X}
}
\value{
a ranged object of the same type as X, but with the inverse set of human genomic ranges selected
}
\description{
Invert a ranged object
Select the empty space between ranges for the whole genome, for instance you may want
to overlap with everything NOT in a set of ranges.
}
\examples{
\donttest{
X <- rranges()
invGRanges(X,inclusive=TRUE)
invGRanges(X)
invGRanges(X,pad.missing.autosomes=FALSE)
}
}
