% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{AH}
\alias{AH}
\title{calculate absolute humidity}
\usage{
AH(e, t, isK = TRUE)
}
\arguments{
\item{e}{partial water vapor pressure in Pascal (Pa)}

\item{t}{temperature in Kelvin (K) or in degree Celsius (°C)}

\item{isK}{logical indicator whether temperature is in Kelvin (K). The default value is TRUE.}
}
\value{
numeric absolute humidity \eqn{\rho_w} (\eqn{kg/m^3})
}
\description{
calculate absolute humidity \eqn{\rho_w} based on partial water vapor pressure \eqn{e} at temperature \eqn{t}
}
\examples{
t <- 273.15
Es <- SVP(t)
e <- WVP2(70, Es)
AH(e, t)
}
\seealso{
\code{\link{WVP1}}, \code{\link{WVP2}}, \code{\link{RH}}, \code{\link{SH}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
