% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{SVP.Murray}
\alias{SVP.Murray}
\title{calculate saturation vapor pressure using the Murray equation}
\usage{
SVP.Murray(t)
}
\arguments{
\item{t}{temperature in Kelvin (K)}
}
\value{
numeric saturation vapor pressure in hectopascal (hPa) or millibar (mb)
}
\description{
calculate saturation vapor pressure \eqn{E_s} at temperature \eqn{t}, per the equation proposed by Murray (1967).
}
\examples{
T0 # absolute zero in Kelvin (K)
SVP.Murray(T0)
}
\references{
Murray, F. W. (1967). \emph{On the Computation of Saturation Vapor Pressure}. Journal of Applied Meteorology, 6(1), 203-204.
}
\seealso{
\code{\link{SVP.ClaCla}}, \code{\link{SVP}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
