% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df.flys}
\alias{df.flys}
\title{Stationary water levels from the FLYS 3-database}
\format{
A \code{data.frame} with 169980 rows and 4 variables:
\describe{
\item{river}{name of the relevant water body (type \code{character}).}
\item{name}{of the FLYS 3 water level (type \code{character}). See details for more information.}
\item{station}{rivers stationing (type \code{numeric}).}
\item{w}{water level (cm above gauge zero, type \code{numeric}).}
}
}
\usage{
df.flys
}
\description{
This dataset contains the 30 stationary 1D water levels for the
  rivers \strong{Elbe} and \strong{Rhine} originally stored in the 
  \href{https://www.bafg.de/DE/08_Ref/M2/03_Fliessgewmod/01_FLYS/flys_node.html}{FLYS3}-database.
  
  For both rivers 30 stationary water levels have been computed by means of 
  the 1D hydraulic model \href{https://download.deltares.nl/en/software/sobek/}{SOBEK}.
  The water levels cover the full length of the free flowing river sections 
  with a spatial resolution of 200 m river stretch along the official 
  river stationing. They range from extremely low to extremely high flow 
  conditions and are usually separated vertically by 0.2 - 0.6 m.
  
  \if{html}{\figure{flys3waterlevels.png}{options: width="60\%" alt="Figure: flys3waterlevels.png" style="text-align: center;"}}
  \if{latex}{\figure{flys3waterlevels.pdf}{options: width=7cm}}
}
\details{
The \code{name}ing of the water levels is \code{river}-specific:

\strong{Elbe:}

'0.5MNQ', 'MNQ', '0.5MQ', 'a', '0.75MQ', 'b', 'MQ', 'c', '2MQ', '3MQ', 'd', 'e', 'MHQ', 'HQ2', 'f', 'HQ5', 'g', 'h', 'HQ10', 'HQ15', 'HQ20', 'HQ25', 'HQ50', 'HQ75', 'HQ100', 'i', 'HQ150', 'HQ200', 'HQ300', 'HQ500'

\strong{Rhine:}

''

Both lists of water levels are ordered from low to high water levels.
}
\references{
\insertRef{busch_einheitliche_2009}{hyd1d}
  
  \insertRef{hkv_hydrokontor_erstellung_2014}{hyd1d}
  
  \insertRef{bundesanstalt_fur_gewasserkunde_flys_2013}{hyd1d}
  
  \insertRef{bundesanstalt_fur_gewasserkunde_flys_2016}{hyd1d}
  
  \insertRef{deltares_sobek_2018}{hyd1d}
}
\keyword{datasets}
