% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_set_value.R
\name{set_value}
\alias{set_value}
\title{Set user defined values}
\usage{
set_value(x, col_name, out_name = NULL, value, from, to)
}
\arguments{
\item{x}{data frame or tibble with class \code{Date} or \code{POSIX*}
in the first column.}

\item{col_name}{string with column(s) name(s) to set.}

\item{out_name}{optional. String with new column(s) name(s). If you set it
as \code{NULL}, the function will overwrite the original data frame.}

\item{value}{numeric vector with the numeric values to set between
dates (\code{from} and \code{to}). If you provide a number it will be
recycled. When using a multiple dates (i.e.: "date" vector in \code{from}
and \code{to}) use a list with a numeric vector inside each element.}

\item{from}{string vector for \code{'Date'} class or \code{POSIX*} class
for date-time data with the starting date.}

\item{to}{string vector for \code{'Date'} class or \code{POSIX*} class
for date-time data with the ending date.}
}
\value{
The same table but with the set numeric values between the dates.
}
\description{
Specify specific values between dates.
}
\examples{

# create a data frame
dates   <- seq.Date(from = as.Date('1990-01-01'), to = as.Date('1990-12-01'), by = 'm')
met_var <- runif(n = 12, 0, 10)

met_table <- data.frame(dates, met_var)

# set single value recycling
set_value(x = met_table, col_name = 'met_var', value = 10,
 from = '1990-01-01', to = '1990-06-01' )

# set different periods
set_value(x = met_table, col_name = 'met_var', value = list(NA_real_, c(1, 2) ),
 from = c('1990-01-01', '1990-11-01'), to = c('1990-06-01', '1990-12-01') )

# now set as new columns
set_value(x = met_table, col_name = 'met_var', out_name = 'met_set',
 value = list(NA_real_, c(1, 2) ),
 from = c('1990-01-01', '1990-11-01'),
  to = c('1990-06-01', '1990-12-01') )

}
