% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/collectData.R
\name{collectData}
\alias{collectData}
\title{Collect data from different csv files.}
\usage{
collectData(folderName, fileType = NULL, range = NULL, sheetIndex = 1)
}
\arguments{
\item{folderName}{A string showing the path of the folder holding different csv files.}

\item{fileType}{A string showing the file type, e.g. "txt", "csv", "excel".}

\item{range}{A vector containing startRow, endRow, startColumn, endColumn, e.g.,
c(2,15,2,3)}

\item{sheetIndex}{A number showing the sheetIndex in the excel file, if fileType is excel,
sheetIndex has to be provided, default is 1.}
}
\value{
The collected data from different files in the folder.
}
\description{
Collect data from different csv files.
}
\examples{
#use internal data as an example.
folder <- file.path(path.package("hyfo"), 'extdata')
# file may vary with different environment, it if doesn't work, use local way to get
# folder path.

a <- collectData(folder, fileType = 'csv', range = c(10, 20, 1,2))

# More examples can be found in the user manual on http://yuanchao-xu.github.io/hyfo/
}

