\name{hyperSMURF.test.thresh}
\alias{hyperSMURF.test.thresh}
\title{
Test of a thresholded hyperSMURF model 
}
\description{
The predictions of each random forest are discrete, i.e. 1 or 0: the probabilities are thresholded according to the \code{cutoff} value set in the training phase. The threshold is embedded in the \code{HSmodel} according to the cutoff parameter set in the training phase.  The score computed by the hyperensemble is the average of the discrete predictions generated by each base random forest. 
}
\usage{
hyperSMURF.test.thresh(data, HSmodel)
}

\arguments{
  \item{data}{
a data frame or matrix with the test data. Rows: examples; columns: features
}
  \item{HSmodel}{
a list including the trained random forest models. The models have been trained with \code{\link{hyperSMURF.train}}. The threshold is embedded in the model according to the \code{cutoff} value set in the training phase.
}
}
\value{
a named vector with the computed probabilities for each example (HyeprSMURF thresholded score)
}

\seealso{
\code{\link{hyperSMURF.test}}, \code{\link{hyperSMURF.train}}
}
\examples{
train <- imbalanced.data.generator(n.pos=20, n.neg=500, 
         n.features=10, n.inf.features=2, sd=0.1, seed=1);
HSmodel <- hyperSMURF.train(train$data, train$label, n.part = 5, 
                  fp = 1, ratio = 2, k = 5, cutoff=c(0.3, 0.7));
test <- imbalanced.data.generator(n.pos=20, n.neg=500, 
         n.features=10, n.inf.features=2, sd=0.1, seed=2);
res <- hyperSMURF.test.thresh(test$data, HSmodel);
}
