% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_values.R
\name{cldr_numbers}
\alias{cldr_numbers}
\title{Get a single localized value from the \link{numbers} dataset}
\usage{
cldr_numbers(
  locale = "en",
  element = numbers_elements$default_numbering_system
)
}
\arguments{
\item{locale}{The locale ID for which to obtain the data from the
\link{numbers} table.}

\item{element}{The element from which information will be obtained for the
specified \code{locale}.}
}
\value{
Either a named list or a length one character vector, depending on
the \code{element} value.
}
\description{
The \link{numbers} table contains localization data for number usage and this data
is available for 571 locales. The \code{cldr_numbers()}
function allows one to extract a named list using a \code{locale} and a specific
\code{element}. The \code{element} values are:
\itemize{
\item \code{"default_numbering_system"}
\item \code{"other_numbering_systems"}
\item \code{"minimum_grouping_digits"}
\item \code{"decimal"}
\item \code{"group"}
\item \code{"list"}
\item \code{"percent_sign" }
\item \code{"plus_sign"}
\item \code{"minus_sign"}
\item \code{"approx_sign"}
\item \code{"exp_sign"}
\item \code{"sup_exp"}
\item \code{"per_mille"}
\item \code{"infinity"}
\item \code{"nan"}
\item \code{"time_sep"}
\item \code{"approx_pattern"}
\item \code{"at_least_pattern"}
\item \code{"at_most_pattern"}
\item \code{"range_pattern"}
\item \code{"decimal_format"}
\item \code{"sci_format"}
\item \code{"percent_format"}
\item \code{"currency_format"}
\item \code{"accounting_format"}
}
}
