% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIARforecast.R
\name{CIAR.forecast}
\alias{CIAR.forecast}
\title{Forecast from CIAR model}
\usage{
CIAR.forecast(phi.R, phi.I, y1, st, n.ahead = 1)
}
\arguments{
\item{phi.R}{Real part of the phi coefficient of CIAR model.}

\item{phi.I}{Imaginary part of the phi coefficient of CIAR model.}

\item{y1}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}

\item{n.ahead}{The number of steps ahead for forecast is required.}
}
\value{
A list with the following components:
\itemize{
\item{fitted}{ Fitted values by the CIAR model.}
\item{forecast}{ Point Forecasts in the n.ahead times.}
\item{Lambda}{ Lambda value estimated by the CIAR model at the last time point.}
\item{Sighat}{ Covariance matrix estimated by the CIAR model at the last time point.}
}
}
\description{
Forecast from models fitted by \code{\link{CIAR.kalman}}
}
\examples{
#Simulated Data
n=100
set.seed(6714)
st<-gentime(n)
x=CIAR.sample(n=n,phi.R=0.9,phi.I=0,sT=st,c=1)
y=x$y
y1=y/sd(y)
n=length(y1)
p=trunc(n*0.99)
ytr=y1[1:p]
yte=y1[(p+1):n]
str=st[1:p]
ste=st[(p+1):n]
n.ahead=ste-str[p]

final<-matrix(0,length(n.ahead),4)
ciar=CIAR.kalman(y=ytr,t=str)
forCIAR<-CIAR.forecast(ciar$phiR,ciar$phiI,ytr,str,n.ahead=n.ahead)

}
\references{
\insertRef{Elorrieta_2019}{iAR}
}
\seealso{
\code{\link{CIAR.sample}}, \code{\link{CIAR.kalman}}, \code{\link{CIAR.fit}}
}
