% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARtinterpolation.R
\name{IARtinterpolation}
\alias{IARtinterpolation}
\title{Interpolation from IAR-T model}
\usage{
IARtinterpolation(x, y, st, nu = 3, yini = 0)
}
\arguments{
\item{x}{A given array with the parameters of the IAR-T model. The first element of the array corresponding to the phi parameter and the second element to the scale parameter sigma}

\item{y}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}

\item{nu}{degrees of freedom}

\item{yini}{a single value, initial value for the estimation of the missing value of the time series.}
}
\value{
A list with the following components:
\itemize{
\item{fitted}{ Estimation of a missing value of the IAR-T process.}
\item{ll}{ Value of the negative log likelihood evaluated in the fitted missing values.}
}
}
\description{
Interpolation of missing values from models fitted by \code{\link{IARt}}
}
\examples{
set.seed(6714)
n<-100
st<-gentime(n)
y<-IARtsample(n,0.9,st,sigma2=1,nu=3)
model<-IARt(y$y, st=st)
napos=10
y0=y$y
y=y$y
y[napos]=NA
xest=c(model$phi,model$sigma)
yest=IARtinterpolation(x=xest,y=y,st=st)
yest$fitted
mse=(y0[napos]-yest$fitted)^2
print(mse)
plot(st,y,type='l',xlim=c(st[napos-5],st[napos+5]))
points(st,y,pch=20)
points(st[napos],yest$fitted,col="red",pch=20)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARtsample}}, \code{\link{IARt}}
}
