% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRtox.R
\name{LRtox}
\alias{LRtox}
\title{Calculates likelihood of safety for single dose}
\usage{
LRtox(coh.size, x, p1, p2, K = 2)
}
\arguments{
\item{coh.size}{cohort size (number of patients) per dose (Stage 1)}

\item{x}{number of observed DLTs}

\item{p1}{toxicity under null (unsafe DLT rate). Values range from 0 - 1.}

\item{p2}{toxicity under alternative (safe DLT rate). Values range from 0 - 1; p1 > p2}

\item{K}{threshold for LR. Takes integer values: 1,2,...(recommended K=2)}
}
\value{
List object that gives the likelihood ratio of safety and indicates whether to escalate to the 
next highest dose level, or stop dose escalation and move onto stage 2.
}
\description{
Function \code{LRtox()} calculates the likelihood of safety for a single dose 
and designates whether to escalate to the next dose (safe) or stop dose escalation and move onto stage 2 (unsafe).
}
\examples{
LRtox(coh.size=3,x=2,p1=0.40,p2=0.15,K=2)
LRtox(coh.size=3,x=1,p1=0.40,p2=0.15,K=2)

}
