% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chmap.R
\name{chmap}
\alias{chmap}
\title{Generates a heat map based on an iClusterVB object}
\usage{
chmap(fit, rho = 0.5, cols = NULL, title = NULL, ...)
}
\arguments{
\item{fit}{A fitted iClusterVB object.}

\item{rho}{The minimum probability of inclusion for features shown on the
heatmap. Default is 0.5. 0 would show all features. Only useful for
VS_method = 1.}

\item{cols}{A vector of colors to use for the clusters. The default is a
random selection of colors.}

\item{title}{A character vector or a single value. Title of the heat map. The
default is "View 1 - Distribution 1", ..., "View R - Distribution R".}

\item{...}{Additional arguments to be passed down to
\code{\link[pheatmap]{pheatmap}}}
}
\value{
Returns a heat map for each data view.
}
\description{
Generates a heat map based on an iClusterVB object
}
\examples{
# Setting up the data
dat1 <- list(
  gauss_1 = sim_data$continuous1_data[c(1:20, 61:80, 121:140, 181:200), 1:75],
  gauss_2 = sim_data$continuous2_data[c(1:20, 61:80, 121:140, 181:200), 1:75],
  poisson_1 = sim_data$count_data[c(1:20, 61:80, 121:140, 181:200), 1:75],
  multinomial_1 = sim_data$binary_data[c(1:20, 61:80, 121:140, 181:200), 1:75]
)

# Recoding `0`s to `2`s
dat1$multinomial_1[dat1$multinomial_1 == 0] <- 2

dist <- c(
  "gaussian", "gaussian",
  "poisson", "multinomial"
)

fit_iClusterVB <- iClusterVB(
  mydata = dat1,
  dist = dist,
  K = 4,
  initial_method = "VarSelLCM",
  VS_method = 1,
  max_iter = 25
)


# We can set the colors
chmap(fit_iClusterVB, cols = c("red", "blue", "green", "purple"))

# We can turn off scaling and set titles

chmap(fit_iClusterVB,
  cols = c("red", "blue", "green", "purple"),
  title = c("Gene Expression", "DNA Methylation", "Copy Number", "Mutation Status"),
  scale = "none"
)
}
