% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_umeyama.R
\name{graph_match_Umeyama}
\alias{graph_match_Umeyama}
\title{Spectral Graph Matching Methods: Umeyama Algorithm}
\usage{
graph_match_Umeyama(A, B, seeds = NULL, similarity = NULL)
}
\arguments{
\item{A}{A matrix, 'igraph' object, or list of either.}

\item{B}{A matrix, 'igraph' object, or list of either.}

\item{seeds}{A vector of integers or logicals, a matrix or a data frame. If
the seed pairs have the same indices in both graphs then seeds can be a
vector. If not, seeds must be  a matrix
or a data frame, with the first column being the indices of \eqn{G_1} and
the second column being the corresponding indices of \eqn{G_2}.}

\item{similarity}{A matrix. An \code{n-by-n} matrix containing vertex similaities.}
}
\value{
\code{graph_match_Umeyama} returns a list of graph matching
  results, including the graph matching formula, a data frame containing the
  matching correspondence between \eqn{G_1} and \eqn{G_2} named \code{corr_A}
  and \code{corr_B} and seeds.
}
\description{
Spectral Graph Matching Methods: Umeyama Algorithm
}
\examples{
# match G_1 & G_2 using Umeyama algorithm
G <- sample_correlated_gnp_pair(10, .9, .5)
g1 <- G$graph1
g2 <- G$graph2
startm <- matrix(0, 10, 10)
diag(startm)[1:4] <- 1
graph_match_Umeyama(g1, g2, similarity = startm)

}
\references{
S. Umeyama (1988), \emph{An eigendecomposition approach to weighted
  graph matching problems}. IEEE TPAMI. USA, pages 695-703.
}
