\name{Data_spider}
\alias{Data_spider}
\docType{data}
\title{
  Spider abundance data
}
\description{
  These data were sampled in a mountain forest ecosystem in the Bavarian Forest National Park, Germany (Thorn et al. 2016, 2017).
  A total of 12 experimental plots were established in "closed forest" stands (6 plots) and "open forest" stands with naturally occurring gaps and edges (6 plots) to assess the effects of microclimate on communities of epigeal (ground-dwelling) spiders. \cr
  Epigeal spiders were sampled over three years with four pitfall traps in each plot, yielding a total of 3171 individuals belonging to 85 species recorded in the pooled habitat. In the open forest, there were 1760 individuals representing 74 species, whereas in the closed forest, there were 1411 individuals representing 44 species.
  
}
\usage{data("Data_spider")}
\format{
  \code{Woody_plants} is a species-by-assemblages data.frame with 85 species in two sites. \cr
  $ Open  : int  350 325 237 102 91 72 68 61 53 50 ... \cr
  $ Closed: int  10 55 502 1 3 4 171 140 180 24 ... \cr
}
\source{
  Thorn, S., Bassler, C., Svoboda, M., & Muller, J. (2017). Effects of natural disturbances and salvage logging on biodiversity - les- sons from the bohemian Forest. Forest Ecology and Management, 388, 113-119. https://doi.org/10.1016/j.foreco.2016.06.006 \cr\cr
  Thorn, S., Bubler, H., Fritze, M. -A., Goeder, P., Muller, J., Weib, I., & Seibold, S. (2016). Canopy closure determines arthropod assemblages in microhabitats created by windstorms and salvage logging. Forest Ecology and Management, 381, 188-195. https://doi.org/10.1016/j.foreco.2016.09.029 \cr\cr
}
\examples{
  data(Data_spider)
}

  
\keyword{datasets}
