% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{EstSimpson}
\alias{EstSimpson}
\title{Estimation of Gini-Simpson index or Simpson diversity}
\usage{
EstSimpson(x, datatype = "abundance", transform = FALSE, conf = 0.95,
  B = 200)
}
\arguments{
\item{x}{a vector of species abundances or incidence frequencies. If \code{datatype = "incidence"},
then the first entry of the input data must be total number of sampling units, followed by species incidence frequencies.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}) or sampling-unit-based incidence data (\code{datatype = "incidence"}).}

\item{transform}{a \code{logical} constant to compute traditional Gini-Simpson index (\code{transform=FALSE}) or the transformed Simpson diversity (\code{transform=TRUE}).}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}

\item{B}{an integer specifying the number of bootstrap replications.}
}
\value{
a vector of observed Gini-Simpson index/diversity, estimate of index/diversity, s.e. and the associated confidence interval.
}
\description{
\code{EstSimpson}: estimation of Gini-Simpson index or the transformed Simpson diversity based on the methods proposed in Good (1953) and Chao et al. (2014).
}
\examples{
data(spider)
EstSimpson(spider$Girdled, datatype="abundance")
}
\references{
Chao, A., Gotelli, N.J., Hsieh, T.C., Sander, E.L., Ma, K.H., Colwell, R.K. & Ellison, A.M. (2014) Rarefaction and extrapolation with Hill numbers: a framework for sampling and estimation in species diversity studies. Ecological Monographs, 84, 45-67.\cr\cr
Good, I.J. (1953) The population frequencies of species and the estimation of population parameters. Biometrika, 40, 237-264.
}
\seealso{
\code{\link{ChaoSpecies}, \link{ChaoEntropy}}
}

