% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstIndex.R
\name{ChaoShannon}
\alias{ChaoShannon}
\title{Estimation of Shannon entropy/diversity}
\usage{
ChaoShannon(x, datatype = "abundance", transform = FALSE, conf = 0.95, B = 200)
}
\arguments{
\item{x}{a \code{matrix}, \code{data.frame} (species by sites), or \code{list} of species abundances or incidence frequencies. If \code{datatype = "incidence_freq"}, 
then the first entry of the input data must be total number of sampling units, followed by species incidence frequencies.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}),
sampling-unit-based incidence frequencies data (\code{datatype = "incidence_freq"}) or species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}).}

\item{transform}{a \code{logical} constant to compute traditional Shannon entropy index (\code{transform=FALSE}) or the transformed Shannon diversity (\code{transform=TRUE}).}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}

\item{B}{an integer specifying the number of bootstrap replications.}
}
\value{
A data.frame of observed Shannon entropy/diversity, estimate of entropy/diversity, s.e. and the associated confidence interval.
}
\description{
\code{ChaoShannon}: estimation of Shannon entropy or transformed Shannon diversity based on the method proposed by Chao et al. (2013)
}
\examples{
data(spider)
ChaoShannon(spider$Girdled, datatype="abundance")
}
\references{
Chao, A., Wang, Y.T. & Jost, L. (2013) Entropy and the species accumulation curve: a novel entropy estimator via discovery rates of new species. Methods in Ecology and Evolution, 4, 1091-1100.
}
\seealso{
\code{\link{ChaoRichness}, \link{ChaoSimpson}}
}
