% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiNEXT.R
\name{ggiNEXT}
\alias{ggiNEXT}
\alias{ggiNEXT.iNEXT}
\alias{ggiNEXT.default}
\title{ggplot2 extension for an iNEXT object}
\usage{
ggiNEXT(
  x,
  type = 1,
  se = TRUE,
  facet.var = "None",
  color.var = "Assemblage",
  grey = FALSE
)

\method{ggiNEXT}{iNEXT}(
  x,
  type = 1,
  se = TRUE,
  facet.var = "None",
  color.var = "Assemblage",
  grey = FALSE
)

\method{ggiNEXT}{default}(x, ...)
}
\arguments{
\item{x}{an \code{iNEXT} object computed by \code{\link{iNEXT}}.}

\item{type}{three types of plots: sample-size-based rarefaction/extrapolation curve (\code{type = 1}); 
sample completeness curve (\code{type = 2}); coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{se}{a logical variable to display confidence interval around the estimated sampling curve.}

\item{facet.var}{create a separate plot for each value of a specified variable: 
no separation \cr (\code{facet.var="None"}); 
a separate plot for each diversity order (\code{facet.var="Order.q"}); 
a separate plot for each assemblage (\code{facet.var="Assemblage"}); 
a separate plot for each combination of order x assemblage (\code{facet.var="Both"}).}

\item{color.var}{create curves in different colors for values of a specified variable:
all curves are in the same color (\code{color.var="None"}); 
use different colors for diversity orders (\code{color.var="Order.q"}); 
use different colors for sites (\code{color.var="Assemblage"}); 
use different colors for combinations of order x assemblage (\code{color.var="Both"}).}

\item{grey}{a logical variable to display grey and white ggplot2 theme.}

\item{...}{other arguments passed on to methods. Not currently used.}
}
\value{
a ggplot2 object
}
\description{
\code{ggiNEXT}: the \code{\link[ggplot2]{ggplot}} extension for \code{\link{iNEXT}} Object to plot sample-size- and coverage-based rarefaction/extrapolation curves along with a bridging sample completeness curve
}
\examples{
# single-assemblage abundance data
data(spider)
out1 <- iNEXT(spider$Girdled, q=0, datatype="abundance")
ggiNEXT(x=out1, type=1)
ggiNEXT(x=out1, type=2)
ggiNEXT(x=out1, type=3)

\dontrun{
# single-assemblage incidence data with three orders q
data(ant)
size <- round(seq(10, 500, length.out=20))
y <- iNEXT(ant$h500m, q=c(0,1,2), datatype="incidence_freq", size=size, se=FALSE)
ggiNEXT(y, se=FALSE, color.var="Order.q")

# multiple-assemblage abundance data with three orders q
z <- iNEXT(spider, q=c(0,1,2), datatype="abundance")
ggiNEXT(z, facet.var="Assemblage", color.var="Order.q")
ggiNEXT(z, facet.var="Both", color.var="Both")
}
}
