% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.pca.R
\name{preview.pca}
\alias{preview.pca}
\title{Statistical description before using function ispca}
\usage{
preview.pca(x, L, scale.x = TRUE)
}
\arguments{
\item{x}{list of data matrices, L datasets of explanatory variables.}

\item{L}{numeric, number of data sets.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}
}
\value{
An 'ispca' object that contains the list of the following items.
\itemize{
\item{x:}{ list of data matrices, L datasets of explanatory variables with centered columns. If scale.x is TRUE, the columns of L datasets are standardized to have mean 0 and standard deviation 1.}
\item{eigenvalue:}{ the estimated first eigenvalue.}
\item{eigenvector:}{ the estimated first eigenvector.}
\item{component:}{ the estimated first component.}
\item{meanx:}{ list of numeric vectors, column mean of the original datasets x.}
\item{normx:}{ list of numeric vectors, column standard deviation of the original datasets x.}
}
}
\description{
The function describes the basic statistical information of the data, including sample mean, sample co-variance of X and Y, the first eigenvector, eigenvalue and principal component, etc.
}
\examples{
# Load a list with 3 data sets
library(iSFun)
data("simData.pca")
x <- simData.pca$x
L <- length(x)

prev.pca <- preview.pca(x = x, L = L, scale.x = TRUE)

}
\seealso{
See Also as \code{\link{ispca}}.
}
