% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{set_icd_class}
\alias{set_icd_class}
\alias{as.icd9}
\alias{as.icd9cm}
\alias{as.icd9cm_pc}
\alias{as.icd10}
\alias{as.icd10cm}
\alias{as.icd10cm_pc}
\alias{as.icd10who}
\alias{as.icd10fr}
\alias{as.icd10be}
\title{Construct ICD-9 and ICD-10 data types}
\usage{
as.icd9(x)

as.icd9cm(x)

as.icd9cm_pc(x)

as.icd10(x)

as.icd10cm(x, short_code = NULL)

as.icd10cm_pc(x)

as.icd10who(x, short_code = NULL)

as.icd10fr(x, short_code = NULL)

as.icd10be(x, short_code = NULL)
}
\arguments{
\item{x}{object to set class \code{icd9}}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}
}
\description{
Takes an R structure and sets class to an ICD type. In the case of ICD-9 and
ICD-10 codes, if a particular sub-type is set, e.g. ICD-9-CM (\code{icd9cm}),
then an ICD-9 class (\code{icd9}) is also set.
}
\details{
The \code{as.*} functions e.g. \code{as.icd9}, do checking and try to put
multiple classes in a nice order. Calling the internal bare constructor, e.g.
\code{icd:::icd9} just prepends the new class and returns without any checks,
which is much faster.

Some features make more sense as attributes. E.g. setting code type to
\code{short} or \code{decimal}.
}
\section{Functions}{
\itemize{
\item \code{as.icd9}: Use generic ICD-9 class for this data. Ideally, use
the more specific \code{icd9cm} or other sub-classes (when available).

\item \code{as.icd9cm}: Use ICD-9-CM

\item \code{as.icd9cm_pc}: Indicate the data are ICD-9-CM procedure codes.

\item \code{as.icd10}: Use generic ICD-10 class for this data. If
possible, use the more specific \code{icd10who} or \code{icd10cm}.

\item \code{as.icd10cm}: Use ICD-10-CM (USA) class for the given data

\item \code{as.icd10cm_pc}: Indicate the data are ICD-10-CM procedure codes.

\item \code{as.icd10who}: Use WHO ICD-10 class for the given data

\item \code{as.icd10fr}: Use ICD-10-FR (France) class for the given data

\item \code{as.icd10be}: Use ICD-10-BE (Belgium) class for the given data
}}

\examples{
x <- as.icd10("A1009")
attr(x, "icd_short_diag") <- TRUE
x
attributes(x) <- list(icd_short_diag = NULL)
x

y <- as.decimal_diag(as.icd10("A10.09"))
y
is.short_diag(y)

j <- as.short_diag(as.icd10(c("A11", "B2222")))
j[2] <- "C33"
stopifnot(is.short_diag(j))
stopifnot(is.icd10(j), is.icd10(j[1]), is.icd10(j[[1]]))
j[[1]] <- "D44001"
stopifnot(is.short_diag(j))
stopifnot(is.icd10(j), is.icd10(j[2]), is.icd10(j[[2]]))
}
\seealso{
Other ICD data types: 
\code{\link{as.comorbidity_map}()},
\code{\link{wide_vs_long}}
}
\concept{ICD data types}
