% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9CondenseToExplain}
\alias{icd9CondenseToExplain}
\title{condense list of short ICD-9 code into minimal set of parent descriptions}
\usage{
icd9CondenseToExplain(icd9Short, invalidAction = c("stop", "ignore", "silent",
  "warn"))
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\description{
This can be thought of as the inverse operation to expanding a
  range. The list given must already contain the parents, because this
  function will never add a parent ICD-9 which, although may have all
  children present, may itself have an additional clinical meaning. In
  addition, in contrast to \code{icd9CondenseToMajor}, this function only walks
  back up to parents which have descriptions in \code{icd9Hierarchy}, so it is
  useful for generating a minimal textual description of a set of ICD-9
  codes.
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{icd9ExpandRangeDecimal}};
  \code{\link{\%i9mj\%}},
  \code{\link{icd9ExpandRangeMajor}};
  \code{\link{\%i9s\%}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9ChildrenDecimal}};
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9CondenseToMajor}};
  \code{\link{icd9ExpandMinor}},
  \code{\link{icd9ExpandMinorE}},
  \code{\link{icd9ExpandMinorNV}};
  \code{\link{icd9PrecedingMinors}},
  \code{\link{icd9SubsequentMinors}}
}
\keyword{manip}

