% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/valid.R
\name{icd9GetValid}
\alias{icd9GetInvalid}
\alias{icd9GetInvalidDecimal}
\alias{icd9GetInvalidShort}
\alias{icd9GetValid}
\alias{icd9GetValidDecimal}
\alias{icd9GetValidShort}
\title{invalid subset of decimal or short ICD-9 codes}
\usage{
icd9GetValid(icd9, isShort = icd9GuessIsShort(icd9))

icd9GetValidDecimal(icd9Decimal)

icd9GetValidShort(icd9Short)

icd9GetInvalid(icd9, isShort = icd9GuessIsShort(icd9))

icd9GetInvalidDecimal(icd9Decimal)

icd9GetInvalidShort(icd9Short)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}
}
\description{
Given vector of short or decimal ICD-9 codes, return (in the
  same format) those codes which are valid or invalid. Useful for generating
  error messages with the faulty codes if validation fails.
}
\section{Functions}{
\itemize{
\item \code{icd9GetValidDecimal}: 

\item \code{icd9GetValidShort}: 

\item \code{icd9GetInvalid}: 

\item \code{icd9GetInvalidDecimal}: 

\item \code{icd9GetInvalidShort}: 
}}
\keyword{manip}

