% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.dls.R
\name{write.dls}
\alias{write.dls}
\title{Write DLS3.2 Results to File}
\usage{
write.dls(x, file = "")
}
\arguments{
\item{x}{a list generated by the \code{DLS3.2} function.}

\item{file}{a filename.}
}
\description{
Write results from the \code{DLS3.2} advisory method to a file.
}
\note{
The resulting text file has Dos line endings (CRLF).
}
\examples{
\dontrun{
survey <- data.frame(year=2001:2010, randu[1:10,])
dls <- icesAdvice::DLS3.2(1000, survey$y)

write.dls(dls, "dls.txt")
read.dls("dls.txt")

file.remove("dls.txt")
}

}
\seealso{
\code{\link{read.dls}} reads \code{DLS3.2} results from a file back into R.

\code{\link[icesAdvice]{DLS3.2}} in the \pkg{icesAdvice} package can be used
to calculate catch advice for data-limited stocks (DLS).

\code{\link{icesTAF-package}} gives an overview of the package.
}
