% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt.R
\name{tt}
\alias{tt}
\title{TAF Transpose}
\usage{
tt(x, column = FALSE)
}
\arguments{
\item{x}{a data frame in TAF format.}

\item{column}{a logical indicating whether the group names should be stored
in a column called \samp{Age} instead of in row names. Alternatively,
\code{column} can be a string supplying another name for that first
column.}
}
\value{
A data frame with years as column names.
}
\description{
Convert a table from TAF format to transposed crosstab format.
}
\note{
Transposing can be useful when comparing TAF tables to stock assessment
reports.
}
\examples{
taf2xtab(catage.taf)
tt(catage.taf)
tt(catage.taf, TRUE)
tt(catage.taf, "Custom")

}
\seealso{
\code{\link{catage.taf}} describes the TAF format.

\code{\link{taf2xtab}} converts a TAF table to crosstab format, without
transposing.

\code{\link{icesTAF-package}} gives an overview of the package.
}
