% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catage.long.R
\docType{data}
\name{catage.long}
\alias{catage.long}
\title{Catch at Age in Long Format}
\format{Data frame containing three columns:
\tabular{ll}{
  \code{Year}  \tab year\cr
  \code{Age}   \tab age\cr
  \code{Catch} \tab catch (millions of individuals)
}}
\source{
ICES (2016) Report of the working group on the assessment of demersal stocks
in the North Sea and Skagerrak (WGNSSK).
\href{http://ices.dk/sites/pub/Publication\%20Reports/Expert\%20Group\%20Report/acom/2016/WGNSSK/01\%20WGNSSK\%20report\%202016.pdf}{\emph{ICES
CM 2016/ACOM:14}}, p. 656.
}
\usage{
catage.long
}
\description{
Small catch-at-age table to describe a long format data frame to store
year-age values.
}
\details{
The data are an excerpt (first years and ages) from the catch-at-age table
for North Sea cod from the ICES (2016) assessment.
}
\examples{
catage.long
long2taf(catage.long)
}
\seealso{
\code{\link{catage.taf}} and \code{\link{catage.xtab}} describe alternative
table formats.

\code{\link{long2taf}} converts a long table to TAF format.

\code{\link{icesTAF-package}} gives an overview of the package.
}
