#' @docType package
#'
#' @name icesVocab-package
#'
#' @aliases icesVocab
#'
#' @title ICES Vocabularies Database Web Services
#'
#' @description
#' R interface to access the RECO POX web services of the ICES (International
#' Council for the Exploration of the Sea) Vocabularies database.
#'
#' @details
#' \emph{Get full tables:}
#' \tabular{ll}{
#'   \code{\link{getCodeTypeList}} \tab all code code types\cr
#'   \code{\link{getCodeList}}     \tab codes of a given type\cr
#'   \code{\link{getCodeDetail}}   \tab details for a given code
#' }
#' \emph{Look up specific codes:}
#' \tabular{ll}{
#'   \code{\link{findAphia}} \tab species code
#' }
#'
#' @author Colin Millar and Arni Magnusson.
#'
#' @references
#' ICES Vocabularies database: \url{http://vocab.ices.dk/}.

NA
