% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findAphia.R
\name{findAphia}
\alias{findAphia}
\title{Find Aphia Code}
\usage{
findAphia(species, latin = FALSE, regex = FALSE, full = FALSE)
}
\arguments{
\item{species}{the species name, either in English (default) or Latin.}

\item{latin}{whether the species name is in Latin.}

\item{regex}{whether to match the species name as a regular expression.}

\item{full}{whether to return a data frame with all species columns.}
}
\value{
A vector of Aphia codes (default) or a data frame if full is TRUE.
}
\description{
Look up Aphia code for a given species.
}
\details{
Species name matches are case-insensitive.
}
\examples{
findAphia("cod")
\dontrun{
findAphia("cod")
findAphia("Gadus morhua", latin = TRUE)

# Multiple matches
findAphia(c("cod", "haddock", "saithe"))

# Regular expressions
findAphia("ray", regex = TRUE, full = TRUE)
findAphia("Sebastes", latin = TRUE, regex = TRUE, full = TRUE)
}
}
\seealso{
\code{\link{getCodeList}} can be used to get all Aphia codes; see example on
that help page.

\code{\link{icesVocab-package}} gives an overview of the package.
}
\author{
Arni Magnusson.
}
