% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCodeTypeList.R
\name{getCodeTypeList}
\alias{getCodeTypeList}
\title{Get Types}
\usage{
getCodeTypeList(date = NULL)
}
\arguments{
\item{date}{restrict output to code types modified after a given date in
yyyy-mm-dd format, e.g. "2010-12-01"}
}
\value{
A data frame.
}
\description{
Get all code types. Mainly useful as a reminder of what code types are
available.
}
\examples{
\donttest{
# Find code type for World Register of Marine Species (WoRMS)
types <- getCodeTypeList()
types[grep("worms", tolower(types$Description)),]

findCodeType("worms", full = TRUE)

# The code type "SpecWoRMS" can be used when calling getCodeList()
}
}
\seealso{
\code{\link{getCodeList}} and \code{\link{getCodeDetail}} get codes of a
given type and code details.

\code{\link{findCodeType}} searches for a code types based on a search string.

\code{\link{icesVocab-package}} gives an overview of the package.
}
