% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/idb.R
\name{idb5}
\alias{idb5}
\title{Retrieve data from the five-year-age-group IDB dataset.}
\usage{
idb5(country, year, variables = NULL, concept = NULL,
  country_name = FALSE, api_key = NULL)
}
\arguments{
\item{country}{A two-character FIPS code, or a vector of FIPS codes, of the countries for which you'd like to retrieve data.}

\item{year}{A year, or a vector of years, for which you'd like to retrieve data.}

\item{variables}{A vector of variables.  Use \code{idb_variables()} for a full list.}

\item{concept}{A concept for which you'd like to retrieve data.  Use \code{idb_concepts()} for a list of options.}

\item{country_name}{If TRUE, returns a column with the long country name along with the FIPS code.}

\item{api_key}{The user's Census API key.  Can be supplied here or set globally in an idbr session with
\code{idb_api_key(api_key)}.}
}
\value{
A data frame with the requested data.
}
\description{
Retrieve data from the five-year-age-group IDB dataset.
}
\examples{
\dontrun{

# World map of infant mortality rates by country for 2016 with plotly

library(idbr)
library(plotly)
library(viridis)

idb_api_key('Your API key goes here')

df <- idb5(country = 'all', year = 2016, variable = 'IMR', country_name = TRUE)

plot_ly(df, z = IMR, text = NAME, locations = NAME, locationmode = 'country names',
        type = 'choropleth', colors = viridis(99), hoverinfo = 'text+z') \%>\%
  layout(title = 'Infant mortality rate (per 1000 live births), 2016',
         geo = list(projection = list(type = 'robinson')))


}
}
\seealso{
\url{http://api.census.gov/data/timeseries/idb/5year.html}
}

