% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_analysis.R
\name{plot.IDEMINFER}
\alias{plot.IDEMINFER}
\title{Plot hypothesis testing results}
\usage{
\method{plot}{IDEMINFER}(x, con.v = 0.05, nlevels = 30, opt = c("pvalue",
  "effect"), ...)
}
\arguments{
\item{x}{A class \code{IDEMINFER} list generated by \code{\link{imInfer}}}

\item{con.v}{Levels of contour plot}

\item{nlevels}{Levels of color scale}

\item{opt}{contour plots of \code{pvalue} or \code{effect}}

\item{...}{Options for \code{filled.contour}}
}
\description{
Generate contour plot of p-values or treatment effect theta for sensitivity
analysis results
}
\details{
The plot will only be generated when bootstrap analysis has been conducted.
}
\examples{
\dontrun{
rst.abc <- imData(abc, trt="TRT", surv="SURV", outcome=c("Y1","Y2"),
                 y0=NULL, endfml="Y2",
                 trt.label = c("UC+SBT", "SAT+SBT"),
                 cov=c("AGE"), duration=365, bounds=c(0,100));
rst.fit  <- imFitModel(rst.abc);
rst.imp <- imImpAll(rst.fit, deltas=c(-0.25,0,0.25),
                    normal=TRUE, chains = 2, iter = 2000, warmup = 1000);
rst.est <- imInfer(rst.imp, n.boot = 100);
plot(rst.est);}

}

