% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetryA2.R
\name{asymmetryA2}
\alias{asymmetryA2}
\title{FUNCTION to calculate karyotype asymmetry}
\usage{
asymmetryA2(dfChrSize)
}
\arguments{
\item{dfChrSize}{name of data.frame}
}
\value{
list
}
\description{
This function reads a data.frame  with columns:
\code{shortArmSize} and \code{longArmSize} and optionally \code{OTU} and
returns a list with the A2 values for the OTUs

If several species present, use column "OTU".
\deqn{A_{2} = \frac{sCL}{xCL}}{%
     A2 = sCL / xCL}

(s = std dev, CL = chr. length, x = mean)

related to:
\deqn{CV_{CL} = A_{2} * 100}{%
      CVCL = A2 * 100}

(CV = coeff. var.)
}
\examples{
asymmetryA2(dfOfChrSize)
as.data.frame(asymmetryA2(bigdfOfChrSize))
asymmetryA2(dfChrSizeHolo)
as.data.frame(asymmetryA2(bigdfChrSizeHolo))
}
\references{
Romero-Zarco. 1986. A New Method for Estimating Karyotype
Asymmetry. Taxon Vol. 35, No. 3  pp. 526-530
}
\seealso{
\code{\link{chrbasicdatamono}}

\code{\link{chrbasicdataHolo}}
}
\keyword{arm}
\keyword{data.frame}
\keyword{size}
