% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namesToColumns.R
\name{namesToColumns}
\alias{namesToColumns}
\title{FUNCTION that modifies marks' names into columns}
\usage{
namesToColumns(
  marksDf,
  dfChrSize,
  markType = c("downArrow", "upArrow", "cMLeft", "cM"),
  amountofSpaces = 13,
  colNumber = 2,
  protruding = 0.2,
  protrudingInt = 0.5,
  circularPlot = TRUE,
  rotation = 0.5,
  defaultStyleMark = "square",
  orderChr = "size",
  halfModDown = NA,
  halfModUp = NA,
  rotatMod = 0
)
}
\arguments{
\item{marksDf}{data.frame with columns: \code{markName,style,markPos}}

\item{dfChrSize}{data.frame, size of chr. Same of plot.}

\item{markType}{character, use
\code{c("downArrow","upArrow","cM","cMLeft")} or a subset}

\item{amountofSpaces}{numeric, number of spaces for each column}

\item{colNumber}{numeric, number of columns}

\item{protruding}{numeric, same as plot, minimal protruding for arrow
marks, equivalent to cM
protruding}

\item{protrudingInt}{numeric, spacing of columns in terms of width of chr.
percent 1 = 100\%.
Defaults to \code{0.5}}

\item{circularPlot}{boolean, use \code{TRUE} for circular plots. Use
\code{FALSE} otherwise}

\item{rotation}{numeric, same as plot, anti-clockwise rotation, defaults to
\code{0.5} which
rotates chr. from top to -90 degrees. (-0.5*\eqn{\pi} )}

\item{defaultStyleMark}{character, if some data in column style missing
fill with this one.
Defaults to \code{"square"}}

\item{orderChr}{character, replaces \code{orderBySize - deprecated} when \code{"size"}, sorts chromosomes by total
length from the largest to the smallest. \code{"original"}: preserves d.f. order. \code{"name"}: sorts alphabetically; \code{"group"}: sorts by group name}

\item{halfModDown}{numeric, for circ. plots, when plotting several
chromosomes in a circular
plot, using a small value \code{0.05} corrects for alignment problems of
\code{downArrows,
cMLeft} labels. Defaults to \code{NA}}

\item{halfModUp}{numeric, for circ. plots, when plotting several
chromosomes in a circular
plot, using a small value \code{0.05} corrects for alignment problems of
\code{upArrows, cM}
labels. Defaults to \code{NA}}

\item{rotatMod}{numeric, for circ. plots, when rotation != 0 (diff.),
corrects alignment of
labels. Defaults to \code{0}}
}
\value{
data.frame
}
\description{
Reads a data.frame with marks' of styles
\code{downArrow,upArrow,cM,cMLeft}
positions. It separates names in columns, avoiding overlap when multiple
close names

Exceptionally this function requires the column style in the
data.frame of marks'
positions.

Returns a data.frame
}
\keyword{data.frame}
\keyword{marks}
