% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.R
\encoding{UTF-8}
\name{nc3}
\alias{nc3}
\title{Lotter method for composite Manning's n}
\usage{
nc3(P, n, R)
}
\arguments{
\item{P}{numeric vector that contains "wetted perimeter of any section i"}

\item{n}{numeric vector that contains "Manning's n of any section i"}

\item{R}{numeric vector that contains "hydraulic radius of any section i"}
}
\value{
numeric vector that contains nc3 as Manning's composite n.
}
\description{
This function computes the composite Manning's n using the Lotter method.
}
\details{
"A composite value of Manning's n for a single channel; that is, for the
main channel only of a compound channel or a canal with laterally varying
roughness."

The equation to find Manning's composite n using the Lotter method is

\deqn{n_c = \frac{PR^\frac{5}{3}}{\sum \limits_{i=1}^N \frac{P_i R_i^\frac{5}{3}}{n_i}}}

\describe{
\item{\emph{\eqn{n_c}}}{Manning's composite n}
\item{\emph{P}}{"wetted perimeter of the entire cross section"}
\item{\emph{R}}{"hydraulic radius of the entire cross section"}
\item{\emph{\eqn{P_i}}}{"wetted perimeter of any section i"}
\item{\emph{\eqn{R_i}}}{"hydraulic radius of any section i"}
\item{\emph{\eqn{n_i}}}{"Manning's n of any section i"}
\item{\emph{N}}{"total number of sections into which the wetted
       perimeter and hydraulic radius are divided"}
}
}
\examples{
library("iemisc")
nc3(n = c(0.0024, 0.035), P = c(23.65, 36.08), R = c(2.02, 6.23))


}
\references{
\enumerate{
   \item Terry W. Sturm, \emph{Open Channel Hydraulics}, 2nd Edition, New York City, New York: The McGraw-Hill Companies, Inc., 2010, page 118-119.
}
}
\seealso{
\code{\link{n}} for Manning's n for natural channels, \code{\link{nc1}}
  for Horton method for composite Manning's n, \code{\link{nc2}} for
  Einstein and Banks method for composite Manning's n, and \code{\link{nc4}}
  for Krishnamurthy and Christensen method for composite Manning's n.
}
