% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counting.test.R
\name{counting.test}
\alias{counting.test}
\title{Performs the counting test}
\usage{
counting.test(B, W)
}
\arguments{
\item{B, W}{Numeric vectors with best observations (\code{B}) and worst observations
(\code{W}).}
}
\value{
A data frame with the following columns
\tabular{ll}{
\code{count} \tab The count test statistic described in Tukey's paper, adjusted for tied observations.
The original test statistic as described originally in the paper need not exist in case
of tied observations, this implemantation remedies this.\cr
\code{good_band_lower_bound} \tab Lower bound for good observations (\code{B}).\cr
\code{good_band_upper_bound} \tab Upper bound for good observations (\code{B}).\cr
\code{bad_band_lower_bound} \tab Lower bound for bad observations (\code{W}).\cr
\code{bad_band_upper_bound} \tab Upper bound for bad observations (\code{W}).
}
}
\description{
This test is based on Tukey's "A Quick, Compact, Two-Sample Test to Duckworth's
Specifications", Technometrics, Vol. 1, No. 1 (1959), p.31-48. The test is chosen here
because of its easy interpretability.
}
\details{
We form \code{rbind(B,W)} and order it. If \code{B} and \code{W}
differ significantly, ordering \code{rbind(B,W)} will find observations of one
group at the top and observations of the other at the bottom. We then count how
many observations of one group are at the top and how many of the other are at the
bottom. The sum of the two values gives us the \code{count} test statistic.
A critical value of \code{count >= 6} correponds to a p-value of roughly 0.05
and is independent of sample size and distributional assumptions.
These clustered observations at the top and bottom of the ordered list also
determine the control bands \code{good_band_lower_bound},
\code{good_band_upper_bound},\code{bad_band_lower_bound},
\code{bad_band_upper_bound}: We look if observations from group \code{B}
are at the top or bottom. The highest/ lowest values for observations of group \code{B}
within that cluser are \code{good_band_lower_bound} and
\code{good_band_upper_bound}. We proceed with group \code{W} respectively. If
no such clusters form at the end of the ordered list, the control bands are
set to -1.
}
