% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igo_state_membership.R
\name{igo_state_membership}
\alias{igo_state_membership}
\title{Extract Memberships of a State}
\usage{
igo_state_membership(state, year = NULL, status = "Full Membership")
}
\arguments{
\item{state}{Any valid name or code of a state as specified on
\link{states2016}. It could be also a vector of states}

\item{year}{Year to be assessed, an integer or an array of year.
If \code{NULL} the latest year available
of the state would be extracted.}

\item{status}{Character or vector with the membership status to be
extracted. See Details
on \link{igo_year_format3}.}
}
\value{
A dataframe.
}
\description{
Extract all the memberships of a state on a specific date.
}
\examples{
# Memberships on two different dates
igo_state_membership("Spain", year = 1850)
igo_state_membership("Spain", year = 1870)
igo_state_membership("Spain", year = 1880:1882)

# Last year
igo_state_membership("ZAN")[, 1:7]

# Use codes to get countries
igo_state_membership("2", year = 1865)

# Extract different status

igo_state_membership("kosovo",
  status = c(
    "Associate Membership",
    "Observer",
    "Full Membership"
  )
)

# Vectorized
igo_state_membership(c("usa", "spain"),
  year = 1870:1871
)

# Use countrycodes package to get additional codes
if (requireNamespace("countrycode", quietly = TRUE)) {
  library(countrycode)
  IT <- igo_state_membership("Italy", year = 1880)
  IT$iso3c <- countrycode(IT$ccode,
    origin = "cown",
    destination = "iso3c"
  )
  head(IT)
}
}
\seealso{
\link{igo_year_format3}, \code{\link[=igo_search_states]{igo_search_states()}},
\link{states2016}.
}
