% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/centrality.R
\name{subgraph_centrality}
\alias{subgraph.centrality}
\alias{subgraph_centrality}
\title{Find subgraph centrality scores of network positions}
\usage{
subgraph_centrality(graph, diag = FALSE)
}
\arguments{
\item{graph}{The input graph, it should be undirected, but the
implementation does not check this currently.}

\item{diag}{Boolean scalar, whether to include the diagonal of the adjacency
matrix in the analysis. Giving \code{FALSE} here effectively eliminates the
loops edges from the graph before the calculation.}
}
\value{
A numeric vector, the subgraph centrality scores of the vertices.
}
\description{
Subgraph centrality of a vertex measures the number of subgraphs a vertex
participates in, weighting them according to their size.
}
\details{
The subgraph centrality of a vertex is defined as the number of closed loops
originating at the vertex, where longer loops are exponentially
downweighted.

Currently the calculation is performed by explicitly calculating all
eigenvalues and eigenvectors of the adjacency matrix of the graph. This
effectively means that the measure can only be calculated for small graphs.
}
\examples{
g <- sample_pa(100, m=4, dir=FALSE)
sc <- subgraph_centrality(g)
cor(degree(g), sc)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com} based on the Matlab
code by Ernesto Estrada
}
\references{
Ernesto Estrada, Juan A. Rodriguez-Velazquez: Subgraph
centrality in Complex Networks. \emph{Physical Review E} 71, 056103 (2005).
}
\seealso{
\code{\link{eigen_centrality}}, \code{\link{page_rank}}
}
\keyword{graphs}

