% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{graph_id}
\alias{graph_id}
\title{Get the id of a graph}
\usage{
graph_id(x, ...)
}
\arguments{
\item{x}{A graph or a vertex sequence or an edge sequence.}

\item{...}{Not used currently.}
}
\value{
The id of the graph, a character scalar. For
vertex and edge sequences the id of the graph they were created from.
}
\description{
Graph ids are used to check that a vertex or edge sequence
belongs to a graph. If you create a new graph by changing the
structure of a graph, the new graph will have a new id.
Changing the attributes will not change the id.
}
\examples{
g <- make_ring(10)
graph_id(g)
graph_id(V(g))
graph_id(E(g))

g2 <- g + 1
graph_id(g2)
}
