% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eulerian.R
\name{has_eulerian_path}
\alias{has_eulerian_path}
\alias{has_eulerian_cycle}
\alias{eulerian_path}
\alias{eulerian_cycle}
\title{Find Eulerian paths or cycles in a graph}
\usage{
has_eulerian_path(graph)

has_eulerian_cycle(graph)

eulerian_path(graph)

eulerian_cycle(graph)
}
\arguments{
\item{graph}{An igraph graph object}
}
\value{
For \code{has_eulerian_path()} and \code{has_eulerian_cycle()}, a logical
value that indicates whether the graph contains an Eulerian path or cycle.
For \code{eulerian_path()} and \code{eulerian_cycle()}, a named list with two
entries: \item{epath}{A vector containing the edge ids along the Eulerian
path or cycle.} \item{vpath}{A vector containing the vertex ids along the
Eulerian path or cycle.}
}
\description{
\code{has_eulerian_path()} and \code{has_eulerian_cycle()} checks whether there
is an Eulerian path or cycle in the input graph. \code{eulerian_path()} and
\code{eulerian_cycle()} return such a path or cycle if it exists, and throws
an error otherwise.
}
\details{
\code{has_eulerian_path()} decides whether the input graph has an Eulerian
\emph{path}, i.e. a path that passes through every edge of the graph exactly
once, and returns a logical value as a result. \code{eulerian_path()} returns
a possible Eulerian path, described with its edge and vertex sequence, or
throws an error if no such path exists.

\code{has_eulerian_cycle()} decides whether the input graph has an Eulerian
\emph{cycle}, i.e. a path that passes through every edge of the graph exactly
once and that returns to its starting point, and returns a logical value as
a result. \code{eulerian_cycle()} returns a possible Eulerian cycle, described
with its edge and vertex sequence, or throws an error if no such cycle exists.
}
\examples{

g <- make_graph(~ A - B - C - D - E - A - F - D - B - F - E)

has_eulerian_path(g)
eulerian_path(g)

has_eulerian_cycle(g)
try(eulerian_cycle(g))

}
\seealso{
Graph cycles
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()}
}
\concept{cycles}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/latest/igraph-Cycles.html#igraph_is_eulerian}{\code{igraph_is_eulerian()}}, \href{https://igraph.org/c/html/latest/igraph-Cycles.html#igraph_eulerian_path}{\code{igraph_eulerian_path()}}, \href{https://igraph.org/c/html/latest/igraph-Cycles.html#igraph_eulerian_cycle}{\code{igraph_eulerian_cycle()}}.}

