% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canny_edges_detector.R
\name{plot.image_canny}
\alias{plot.image_canny}
\title{Plot the result of the Canny Edge Detector}
\usage{
\method{plot}{image_canny}(x, ...)
}
\arguments{
\item{x}{an object of class image_canny as returned by \code{\link{image_canny_edge_detector}}}

\item{...}{further arguments passed on to plot, except type, xlab and ylab which are set inside the function}
}
\value{
invisible()
}
\description{
Plot the result of \code{\link{image_canny_edge_detector}}
}
\examples{
library(pixmap)
imagelocation <- system.file("extdata", "chairs.pgm", package="image.CannyEdges")
image <- read.pnm(file = imagelocation, cellres = 1)
edges <- image_canny_edge_detector(image@grey * 255)
plot(edges)
}
